/*
 * Decompiled with CFR 0.152.
 */
package mod.chiselsandbits.chiseling.modes.sphere;

import com.google.common.collect.Maps;
import com.mojang.datafixers.util.Either;
import java.util.BitSet;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Predicate;
import mod.chiselsandbits.api.blockinformation.BlockInformation;
import mod.chiselsandbits.api.change.IChangeTrackerManager;
import mod.chiselsandbits.api.chiseling.ChiselingOperation;
import mod.chiselsandbits.api.chiseling.IChiselingContext;
import mod.chiselsandbits.api.chiseling.mode.IChiselMode;
import mod.chiselsandbits.api.inventory.bit.IBitInventory;
import mod.chiselsandbits.api.inventory.management.IBitInventoryManager;
import mod.chiselsandbits.api.item.click.ClickProcessingState;
import mod.chiselsandbits.api.item.withmode.group.IToolModeGroup;
import mod.chiselsandbits.api.multistate.StateEntrySize;
import mod.chiselsandbits.api.multistate.accessor.IAreaAccessor;
import mod.chiselsandbits.api.multistate.accessor.IStateEntryInfo;
import mod.chiselsandbits.api.multistate.accessor.world.IInWorldStateEntryInfo;
import mod.chiselsandbits.api.multistate.accessor.world.IWorldAreaAccessor;
import mod.chiselsandbits.api.multistate.mutator.batched.IBatchMutation;
import mod.chiselsandbits.api.multistate.mutator.world.IWorldAreaMutator;
import mod.chiselsandbits.api.util.BlockPosForEach;
import mod.chiselsandbits.api.util.BlockPosStreamProvider;
import mod.chiselsandbits.api.util.LocalStrings;
import mod.chiselsandbits.api.util.RayTracingUtils;
import mod.chiselsandbits.platforms.core.registries.AbstractCustomRegistryEntry;
import mod.chiselsandbits.registrars.ModChiselModeGroups;
import mod.chiselsandbits.registrars.ModMetadataKeys;
import mod.chiselsandbits.utils.BitInventoryUtils;
import mod.chiselsandbits.utils.BlockPosUtils;
import mod.chiselsandbits.utils.ItemStackUtils;
import mod.chiselsandbits.voxelshape.MultiStateBlockEntityDiscreteVoxelShape;
import net.minecraft.class_124;
import net.minecraft.class_156;
import net.minecraft.class_1657;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_239;
import net.minecraft.class_243;
import net.minecraft.class_249;
import net.minecraft.class_251;
import net.minecraft.class_2561;
import net.minecraft.class_2588;
import net.minecraft.class_259;
import net.minecraft.class_265;
import net.minecraft.class_2960;
import net.minecraft.class_3965;
import net.minecraft.class_5250;
import org.jetbrains.annotations.NotNull;

public class SphereChiselMode
extends AbstractCustomRegistryEntry
implements IChiselMode {
    private final int diameter;
    private final class_5250 displayName;
    private final class_5250 multiLineDisplayName;
    private final class_2960 iconName;
    private final Map<StateEntrySize, class_265> baseSphereShapes = Maps.newHashMap();

    SphereChiselMode(int diameter, class_5250 displayName, class_5250 multiLineDisplayName, class_2960 iconName) {
        this.diameter = diameter;
        this.displayName = displayName;
        this.multiLineDisplayName = multiLineDisplayName;
        this.iconName = iconName;
        for (StateEntrySize size : StateEntrySize.values()) {
            this.baseSphereShapes.put(size, SphereChiselMode.buildSphereShape(size, diameter));
        }
    }

    private static class_265 buildSphereShape(StateEntrySize size, int diameter) {
        int blocks = StateEntrySize.ONE_SIXTEENTH.getBitsPerBlockSide() / size.getBitsPerBlockSide();
        int fullBitAccuracy = blocks * StateEntrySize.ONE_SIXTEENTH.getBitsPerBlockSide();
        int centerBitCoord = fullBitAccuracy / 2;
        int radius = diameter / 2;
        class_2338 centerPos = new class_2338(centerBitCoord, centerBitCoord, centerBitCoord);
        class_2338 cornerPos = centerPos.method_10059(new class_2382(radius, 0, 0));
        double range = cornerPos.method_10262((class_2382)centerPos);
        BitSet bits = new BitSet(fullBitAccuracy * fullBitAccuracy * fullBitAccuracy);
        BlockPosForEach.forEachInRange(fullBitAccuracy, blockPos -> {
            int index = BlockPosUtils.getCollisionIndex(blockPos, fullBitAccuracy, fullBitAccuracy);
            double posRange = blockPos.method_10262((class_2382)centerPos);
            bits.set(index, posRange <= range);
        });
        return new class_249((class_251)new MultiStateBlockEntityDiscreteVoxelShape(bits, fullBitAccuracy));
    }

    @Override
    public ClickProcessingState onLeftClickBy(class_1657 playerEntity, IChiselingContext context) {
        Either<ClickProcessingState, class_243> rayTraceHandle = this.processRayTraceIntoContext(playerEntity, context, face -> class_243.method_24954((class_2382)face.method_10153().method_10163()), facing -> facing.method_18805(-1.0, -1.0, -1.0));
        if (rayTraceHandle.right().isPresent()) {
            context.setMetadata(ModMetadataKeys.ANCHOR.get(), (class_243)rayTraceHandle.right().get());
        }
        if (context.isSimulation()) {
            return ClickProcessingState.DEFAULT;
        }
        context.setComplete();
        if (rayTraceHandle.left().isPresent()) {
            return (ClickProcessingState)rayTraceHandle.left().get();
        }
        if (rayTraceHandle.right().isEmpty()) {
            throw new IllegalArgumentException("Missing both a click processing result as well as a center vector for sphere processing");
        }
        return context.getMutator().map(mutator -> {
            try (IBatchMutation ignored = mutator.batch(IChangeTrackerManager.getInstance().getChangeTracker(playerEntity));){
                HashMap resultingBitCount = Maps.newHashMap();
                Predicate<IStateEntryInfo> filter = context.getStateFilter().map(factory -> (Predicate)factory.apply(mutator)).orElse(s -> true);
                int totalModifiedStates = mutator.inWorldMutableStream().filter(filter).mapToInt(state -> {
                    BlockInformation currentState = state.getBlockInformation();
                    return context.tryDamageItemAndDoOrSetBrokenError(() -> {
                        resultingBitCount.putIfAbsent(currentState, 0);
                        resultingBitCount.computeIfPresent(currentState, (s, currentCount) -> currentCount + 1);
                        state.clear();
                    });
                }).sum();
                if (totalModifiedStates == 0) {
                    context.setError(LocalStrings.ChiselAttemptFailedNoValidStateFound.getText());
                }
                resultingBitCount.forEach((blockState, count) -> BitInventoryUtils.insertIntoOrSpawn(playerEntity, blockState, count));
            }
            return ClickProcessingState.ALLOW;
        }).orElse(ClickProcessingState.DEFAULT);
    }

    @Override
    public void onStoppedLeftClicking(class_1657 playerEntity, IChiselingContext context) {
    }

    @Override
    public ClickProcessingState onRightClickBy(class_1657 playerEntity, IChiselingContext context) {
        Either<ClickProcessingState, class_243> rayTraceHandle = this.processRayTraceIntoContext(playerEntity, context, face -> class_243.method_24954((class_2382)face.method_10163()), Function.identity());
        if (rayTraceHandle.right().isPresent()) {
            context.setMetadata(ModMetadataKeys.ANCHOR.get(), (class_243)rayTraceHandle.right().get());
        }
        if (context.isSimulation()) {
            return ClickProcessingState.DEFAULT;
        }
        if (rayTraceHandle.left().isPresent()) {
            return (ClickProcessingState)rayTraceHandle.left().get();
        }
        if (rayTraceHandle.right().isEmpty()) {
            throw new IllegalArgumentException("Missing both a click processing result as well as a center vector for sphere processing");
        }
        return context.getMutator().map(mutator -> {
            class_2338 heightPos;
            BlockInformation heldBlockState = ItemStackUtils.getHeldBitBlockInformationFromPlayer(playerEntity);
            if (heldBlockState.isAir()) {
                return ClickProcessingState.DEFAULT;
            }
            Predicate<IStateEntryInfo> filter = context.getStateFilter().map(factory -> (Predicate)factory.apply(mutator)).orElse(s -> true);
            int missingBitCount = (int)mutator.stream().filter(state -> state.getBlockInformation().isAir() && filter.test((IStateEntryInfo)state)).count();
            IBitInventory playerBitInventory = IBitInventoryManager.getInstance().create(playerEntity);
            context.setComplete();
            if (playerBitInventory.canExtract(heldBlockState, missingBitCount) || playerEntity.method_7337()) {
                if (!playerEntity.method_7337()) {
                    playerBitInventory.extract(heldBlockState, missingBitCount);
                }
                try (IBatchMutation ignored = mutator.batch(IChangeTrackerManager.getInstance().getChangeTracker(playerEntity));){
                    mutator.inWorldMutableStream().filter(state -> state.getBlockInformation().isAir() && filter.test((IStateEntryInfo)state)).forEach(state -> state.overrideState(heldBlockState));
                }
            } else {
                context.setError(LocalStrings.ChiselAttemptFailedNotEnoughBits.getText(heldBlockState.getBlockState().method_26204().method_9518()));
            }
            if (missingBitCount == 0 && (heightPos = new class_2338(mutator.getInWorldEndPoint())).method_10264() >= context.getWorld().method_31600()) {
                class_5250 component = new class_2588("build.tooHigh", new Object[]{context.getWorld().method_31600() - 1}).method_27692(class_124.field_1061);
                playerEntity.method_9203((class_2561)component, class_156.field_25140);
            }
            return ClickProcessingState.ALLOW;
        }).orElse(ClickProcessingState.DEFAULT);
    }

    @Override
    public void onStoppedRightClicking(class_1657 playerEntity, IChiselingContext context) {
    }

    @Override
    public Optional<IAreaAccessor> getCurrentAccessor(IChiselingContext context) {
        return context.getMutator().map(mutator -> mutator);
    }

    @Override
    public boolean isStillValid(class_1657 playerEntity, IChiselingContext context, ChiselingOperation modeOfOperation) {
        Optional<class_243> rayTraceHandle = modeOfOperation.isChiseling() ? this.processRayTraceIntoCenter(playerEntity, face -> class_243.method_24954((class_2382)face.method_10153().method_10163()), facing -> facing.method_18805(-1.0, -1.0, -1.0)) : this.processRayTraceIntoCenter(playerEntity, face -> class_243.method_24954((class_2382)face.method_10163()), Function.identity());
        Optional<class_243> contextAnchor = context.getMetadata(ModMetadataKeys.ANCHOR.get());
        return rayTraceHandle.map(d -> contextAnchor.filter(arg_0 -> ((class_243)d).equals(arg_0)).isPresent()).orElseGet(contextAnchor::isPresent);
    }

    @Override
    public class_265 getShape(IChiselingContext context) {
        Optional<class_243> centerCandidate = context.getMetadata(ModMetadataKeys.ANCHOR.get());
        if (centerCandidate.isEmpty()) {
            return class_259.method_1073();
        }
        Optional<IWorldAreaMutator> accessor = context.getMutator();
        if (accessor.isEmpty()) {
            return class_259.method_1073();
        }
        class_265 genericShape = this.baseSphereShapes.get((Object)StateEntrySize.current());
        class_243 areaStart = accessor.get().getInWorldStartPoint();
        class_2338 areaStartPos = new class_2338(areaStart);
        class_243 center = centerCandidate.get();
        class_243 offset = center.method_1023((double)areaStartPos.method_10263(), (double)areaStartPos.method_10264(), (double)areaStartPos.method_10260());
        int blocks = StateEntrySize.ONE_SIXTEENTH.getBitsPerBlockSide() / StateEntrySize.current().getBitsPerBlockSide();
        int fullBitAccuracy = blocks * StateEntrySize.ONE_SIXTEENTH.getBitsPerBlockSide();
        int centerBitCoord = fullBitAccuracy / 2;
        float centerBitCoordExact = (float)centerBitCoord / 16.0f;
        class_243 shapeOffset = offset.method_1023((double)centerBitCoordExact, (double)centerBitCoordExact, (double)centerBitCoordExact);
        return genericShape.method_1096(shapeOffset.method_10216(), shapeOffset.method_10214(), shapeOffset.method_10215());
    }

    private Optional<class_243> processRayTraceIntoCenter(class_1657 playerEntity, Function<class_2350, class_243> placementFacingAdapter, Function<class_243, class_243> fullFacingVectorAdapter) {
        class_239 rayTraceResult = RayTracingUtils.rayTracePlayer(playerEntity);
        if (rayTraceResult.method_17783() != class_239.class_240.field_1332 || !(rayTraceResult instanceof class_3965)) {
            return Optional.empty();
        }
        class_3965 blockRayTraceResult = (class_3965)rayTraceResult;
        class_243 hitVector = blockRayTraceResult.method_17784().method_1019(placementFacingAdapter.apply(blockRayTraceResult.method_17780()).method_18805((double)StateEntrySize.current().getSizePerHalfBit(), (double)StateEntrySize.current().getSizePerHalfBit(), (double)StateEntrySize.current().getSizePerHalfBit()));
        class_243 centeredHitVector = class_243.method_24954((class_2382)new class_2338(hitVector.method_18805((double)StateEntrySize.current().getBitsPerBlockSide(), (double)StateEntrySize.current().getBitsPerBlockSide(), (double)StateEntrySize.current().getBitsPerBlockSide()))).method_18805((double)StateEntrySize.current().getSizePerBit(), (double)StateEntrySize.current().getSizePerBit(), (double)StateEntrySize.current().getSizePerBit());
        class_243 center = centeredHitVector.method_1019(new class_243((double)this.diameter / 2.0 / (double)StateEntrySize.current().getBitsPerBlockSide(), (double)this.diameter / 2.0 / (double)StateEntrySize.current().getBitsPerBlockSide(), (double)this.diameter / 2.0 / (double)StateEntrySize.current().getBitsPerBlockSide()).method_18806(fullFacingVectorAdapter.apply(class_243.method_24954((class_2382)blockRayTraceResult.method_17780().method_10163()))));
        return Optional.of(center);
    }

    private Either<ClickProcessingState, class_243> processRayTraceIntoContext(class_1657 playerEntity, IChiselingContext context, Function<class_2350, class_243> placementFacingAdapter, Function<class_243, class_243> fullFacingVectorAdapter) {
        class_239 rayTraceResult = RayTracingUtils.rayTracePlayer(playerEntity);
        if (rayTraceResult.method_17783() != class_239.class_240.field_1332 || !(rayTraceResult instanceof class_3965)) {
            context.setError(LocalStrings.ChiselAttemptFailedNoBlock.getText());
            return Either.left((Object)ClickProcessingState.DEFAULT);
        }
        class_3965 blockRayTraceResult = (class_3965)rayTraceResult;
        class_243 hitVector = blockRayTraceResult.method_17784().method_1019(placementFacingAdapter.apply(blockRayTraceResult.method_17780()).method_18805((double)StateEntrySize.current().getSizePerHalfBit(), (double)StateEntrySize.current().getSizePerHalfBit(), (double)StateEntrySize.current().getSizePerHalfBit()));
        class_243 centeredHitVector = class_243.method_24954((class_2382)new class_2338(hitVector.method_18805((double)StateEntrySize.current().getBitsPerBlockSide(), (double)StateEntrySize.current().getBitsPerBlockSide(), (double)StateEntrySize.current().getBitsPerBlockSide()))).method_18805((double)StateEntrySize.current().getSizePerBit(), (double)StateEntrySize.current().getSizePerBit(), (double)StateEntrySize.current().getSizePerBit());
        class_243 center = centeredHitVector.method_1019(new class_243((double)this.diameter / 2.0 / (double)StateEntrySize.current().getBitsPerBlockSide(), (double)this.diameter / 2.0 / (double)StateEntrySize.current().getBitsPerBlockSide(), (double)this.diameter / 2.0 / (double)StateEntrySize.current().getBitsPerBlockSide()).method_18806(fullFacingVectorAdapter.apply(class_243.method_24954((class_2382)blockRayTraceResult.method_17780().method_10163()))));
        context.setStateFilter(areaAccessor -> {
            if (areaAccessor instanceof IWorldAreaAccessor) {
                return new SphereAreaFilter(context.getModeOfOperandus(), ((IWorldAreaAccessor)areaAccessor).getInWorldStartPoint(), center);
            }
            return new SphereAreaFilter(context.getModeOfOperandus(), class_243.field_1353, center);
        });
        BlockPosStreamProvider.getForRange(this.diameter).forEach(bitPos -> {
            class_243 target = center.method_1019(class_243.method_24954((class_2382)bitPos.method_10059(new class_2382(this.diameter / 2, this.diameter / 2, this.diameter / 2))).method_18805((double)StateEntrySize.current().getSizePerBit(), (double)StateEntrySize.current().getSizePerBit(), (double)StateEntrySize.current().getSizePerBit()));
            context.include(target);
        });
        return Either.right((Object)center);
    }

    @Override
    @NotNull
    public class_2960 getIcon() {
        return this.iconName;
    }

    @Override
    public class_2561 getDisplayName() {
        return this.displayName;
    }

    @Override
    public class_2561 getMultiLineDisplayName() {
        return this.multiLineDisplayName;
    }

    @Override
    @NotNull
    public Optional<IToolModeGroup> getGroup() {
        return Optional.of(ModChiselModeGroups.SPHERE);
    }

    private final class SphereAreaFilter
    implements Predicate<IStateEntryInfo> {
        private final ChiselingOperation operation;
        private final class_243 startPoint;
        private final class_243 center;

        private SphereAreaFilter(ChiselingOperation operation, class_243 startPoint, class_243 center) {
            this.operation = operation;
            this.startPoint = startPoint;
            this.center = center;
        }

        @Override
        public boolean test(IStateEntryInfo stateEntryInfo) {
            if (!(stateEntryInfo instanceof IInWorldStateEntryInfo)) {
                return false;
            }
            IInWorldStateEntryInfo inWorldStateEntryInfo = (IInWorldStateEntryInfo)stateEntryInfo;
            return inWorldStateEntryInfo.getInWorldStartPoint().method_1022(this.center) <= (double)((float)SphereChiselMode.this.diameter / 2.0f / (float)StateEntrySize.current().getBitsPerBlockSide()) && (!stateEntryInfo.getBlockInformation().isAir() || this.operation.processesAir());
        }

        public int hashCode() {
            int result = this.startPoint != null ? this.startPoint.hashCode() : 0;
            result = 31 * result + (this.center != null ? this.center.hashCode() : 0);
            return result;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof SphereAreaFilter)) {
                return false;
            }
            SphereAreaFilter that = (SphereAreaFilter)o;
            if (!Objects.equals(this.startPoint, that.startPoint)) {
                return false;
            }
            return Objects.equals(this.center, that.center);
        }
    }
}

